<?php
// Cabeçalho padrão (define BASE_URL, carrega Bootstrap e navbar)
require_once dirname(__DIR__, 2) . '/views/partials/header.php';
?>
<div class="content-box">
  <div class="d-flex align-items-center justify-content-between mb-2">
    <h1 class="m-0">Gestão de Usuários do Sistema</h1>
    <a href="#" class="btn btn-outline-secondary btn-sm" onclick="history.back();return false;">
      <i class="bi bi-arrow-left"></i> Voltar
    </a>
  </div>
  <p style="color:#6b7280;margin-top:-6px;margin-bottom:16px;font-size:14px;">Administração › Usuários</p>

  <?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success"><?= $_SESSION['success_message'] ?></div>
    <?php unset($_SESSION['success_message']); ?>
  <?php endif; ?>
  <?php if (isset($_SESSION['error_message'])): ?>
    <div class="alert alert-danger"><?= $_SESSION['error_message'] ?></div>
    <?php unset($_SESSION['error_message']); ?>
  <?php endif; ?>

  <div class="admin-grid" style="display:grid;grid-template-columns:1fr 1fr;gap:16px;">
    <!-- Cadastro rápido de usuário -->
    <div class="user-form-container" style="background:#f9fafb;border:1px solid #e5e7eb;border-radius:8px;padding:16px;">
      <h2 style="margin-top:0;display:flex;align-items:center;gap:8px;">Novo Usuário</h2>
      <form action="<?= BASE_URL ?>/paineladmin/criarUsuario" method="POST">
        <div class="form-group" style="margin-bottom:12px;">
          <label for="nome">Nome:</label>
          <input type="text" id="nome" name="nome" required style="width:100%;padding:8px;border:1px solid #ddd;border-radius:6px;">
        </div>
        <div class="form-group" style="margin-bottom:12px;">
          <label for="email">Email:</label>
          <input type="email" id="email" name="email" required style="width:100%;padding:8px;border:1px solid #ddd;border-radius:6px;">
        </div>
        <div class="form-group" style="margin-bottom:12px;">
          <label for="senha">Senha:</label>
          <input type="password" id="senha" name="senha" required style="width:100%;padding:8px;border:1px solid #ddd;border-radius:6px;">
        </div>
        <div class="form-group" style="margin-bottom:16px;">
          <label for="nivel_acesso">Nível de Acesso:</label>
          <select id="nivel_acesso" name="nivel_acesso" required style="width:100%;padding:8px;border:1px solid #ddd;border-radius:6px;">
            <option value="Admin">Admin</option>
            <option value="Acesso_Total">Acesso Total</option>
            <option value="Agendas">Agendas</option>
            <option value="Documentos">Documentos</option>
            <option value="Eleitores">Eleitores</option>
            <option value="Financeiro">Financeiro</option>
            <option value="RH">RH</option>
          </select>
        </div>
        <button type="submit" class="btn btn-primary">
          <i class="bi bi-person-plus"></i> Criar Usuário
        </button>
      </form>
      <p style="color:#6b7280;margin-top:10px;font-size:13px;">Após criar, ajuste permissões e ative/desative na lista de usuários.</p>
    </div>

    <!-- Atalhos de administração de usuários -->
    <div class="links-container" style="background:#f9fafb;border:1px solid #e5e7eb;border-radius:8px;padding:16px;">
      <h2 style="margin-top:0;display:flex;align-items:center;gap:8px;">Acessos Rápidos</h2>
      <div style="display:flex;flex-direction:column;gap:10px;">
        <a href="<?= BASE_URL ?>/paineladmin/usuarios" class="btn btn-dark">
          <i class="bi bi-people"></i> Listar Usuários
        </a>
        <a href="<?= BASE_URL ?>/paineladmin/niveisAcesso" class="btn btn-success">
          <i class="bi bi-shield-lock"></i> Gerenciar Níveis de Acesso
        </a>
        <a href="<?= BASE_URL ?>/paineladmin/criarUsuario" class="btn btn-teal" style="background:#0f766e;color:#fff;">
          <i class="bi bi-plus-circle"></i> Abrir Página de Criação
        </a>
      </div>
      <hr style="margin:16px 0;border:none;border-top:1px solid #e5e7eb;">
      <p style="color:#6b7280;font-size:13px;">Crie usuários, defina senhas e gerencie níveis com rapidez.</p>
    </div>
  </div>
</div>
<style>
.alert { padding: 15px; margin-bottom: 20px; border: 1px solid transparent; border-radius: 4px; }
.alert-success { color: #155724; background-color: #d4edda; border-color: #c3e6cb; }
.alert-danger { color: #721c24; background-color: #f8d7da; border-color: #f5c6cb; }
</style>
<?php
// Rodapé padrão
require_once dirname(__DIR__, 2) . '/views/partials/footer.php';
?>
