<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// Proteção de rota
if (empty($_SESSION['user_id'])) {
    header('Location: /gabinete/login.php', true, 302);
    exit;
}

// Configurações
require_once __DIR__ . '/../../config/config.php';

$BASE_PATH = '/gabinete';
$BASE_URL = 'http://localhost:8888/gabinete';
$nome = $_SESSION['nome'] ?? 'Usuário';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastrar Eleitor - Gabinete</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #88589dff;
            --secondary-color: #88589dff;
            --accent-color: #3b82f6;
            --hover-color: #2563eb;
        }
        
        body { 
            background: var(--primary-color);
            min-height: 100vh; 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        /* Cabeçalho com cor azul personalizada */
        .navbar-custom {
            background: linear-gradient(135deg, #070849ff, #070849ff) !important;
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .content-container { 
            background: white; 
            border-radius: 12px; 
            box-shadow: 0 2px 8px rgba(0,0,0,0.05); 
            margin: 20px 0; 
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom">
        <div class="container-fluid">
            <span class="navbar-brand">
                <i class="bi bi-person-plus-fill me-2"></i>
                Cadastrar Eleitor
            </span>
            <div class="d-flex align-items-center text-white">
                <span class="me-3">Olá, <?= htmlspecialchars($nome) ?></span>
                <a href="<?= $BASE_URL ?>/src/views/eleitores/lista.php" class="btn btn-outline-light btn-sm me-2">
                    <i class="bi bi-arrow-left me-1"></i>Voltar
                </a>
                <a href="<?= $BASE_URL ?>/src/views/dashboard/" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-house-fill me-1"></i>Painel
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid py-4">
        <div class="content-container p-4">

<div class="content-box">
    <h1><i class="fas fa-user-plus"></i> Cadastrar Eleitor</h1>
    <p>Preencha os dados abaixo para adicionar um novo eleitor ao sistema.</p>

    <form action="<?= $BASE_URL ?>/src/controllers/EleitoresController.php" method="POST" class="form-container">
        
        <h2><i class="fas fa-id-card"></i> Dados Pessoais</h2>
        <div class="form-row">
            <div class="form-group col-md-8">
                <label for="nome_completo">Nome Completo:</label>
                <input type="text" id="nome_completo" name="nome_completo" required>
            </div>
            <div class="form-group col-md-4">
                <label for="data_nascimento">Data de Nascimento:</label>
                <input type="date" id="data_nascimento" name="data_nascimento">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-4">
                <label for="telefone">Telefone:</label>
                <input type="text" id="telefone" name="telefone">
            </div>
            <div class="form-group col-md-8">
                <label for="email">E-mail:</label>
                <input type="email" id="email" name="email">
            </div>
        </div>
        
        <hr>

        <h2><i class="fas fa-map-marker-alt"></i> Endereço</h2>
        <div class="form-row">
             <div class="form-group col-md-12">
                <label for="endereco">Endereço:</label>
                <input type="text" id="endereco" name="endereco">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="bairro">Bairro:</label>
                <input type="text" id="bairro" name="bairro">
            </div>
            <div class="form-group col-md-4">
                <label for="cidade">Cidade:</label>
                <input type="text" id="cidade" name="cidade" value="Belém">
            </div>
             <div class="form-group col-md-2">
                <label for="cep">CEP:</label>
                <input type="text" id="cep" name="cep">
            </div>
        </div>

        <hr>
        
        <!-- SEÇÃO DE DEMANDA ADICIONADA -->
        <h2><i class="fas fa-bullhorn"></i> Demanda Inicial (Opcional)</h2>
        <p>Se houver uma demanda inicial para este eleitor, preencha os campos abaixo.</p>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="demanda_categoria">Categoria da Demanda:</label>
                <select id="demanda_categoria" name="demanda[categoria]">
                    <option value="">Nenhuma demanda</option>
                    <option value="Saúde">Saúde</option>
                    <option value="Jurídico">Jurídico</option>
                    <option value="Assistência Social">Assistência Social</option>
                    <option value="Ação Social">Ação Social</option>
                    <option value="Reunião">Reunião</option>
                    <option value="Visita">Visita</option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="demanda_titulo">Título da Demanda:</label>
                <input type="text" id="demanda_titulo" name="demanda[titulo]" placeholder="Ex: Agendamento de consulta">
            </div>
        </div>
        <div class="form-group">
            <label for="demanda_descricao">Descrição da Demanda:</label>
            <textarea id="demanda_descricao" name="demanda[descricao]" rows="3"></textarea>
        </div>

        <hr>


        <h2><i class="fas fa-info-circle"></i> Outras Informações</h2>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="sexo">Sexo:</label>
                <select id="sexo" name="sexo">
                    <option value="">Selecione...</option>
                    <option value="Masculino">Masculino</option>
                    <option value="Feminino">Feminino</option>
                    <option value="Outro">Outro</option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="tipo">Tipo:</label>
                <select id="tipo" name="tipo" required>
                    <option value="Apoiador">Apoiador</option>
                    <option value="Liderança">Liderança</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="observacao">Observação Geral:</label>
            <textarea id="observacao" name="observacao" rows="4"></textarea>
        </div>

        <div class="form-actions">
            <button type="submit" class="btn-primary">Salvar Eleitor</button>
            <a href="<?= $BASE_URL ?>/src/views/eleitores/lista.php" class="btn-secondary">Cancelar</a>
        </div>
    </form>
</div>

        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Função para consulta de CEP e autopreenchimento
        document.getElementById('cep').addEventListener('blur', function() {
            // Limpa o CEP para deixar apenas números
            let cep = this.value.replace(/\D/g, '');
            
            // Verifica se o CEP tem 8 dígitos
            if (cep.length !== 8) {
                return;
            }
            
            // Mostra indicador de carregamento
            this.value = 'Buscando...';
            
            // Faz a consulta à API ViaCEP
            fetch(`https://viacep.com.br/ws/${cep}/json/`)
                .then(response => response.json())
                .then(data => {
                    // Verifica se a API retornou erro
                    if (data.erro) {
                        alert('CEP não encontrado');
                        document.getElementById('cep').value = '';
                        return;
                    }
                    
                    // Preenche os campos com os dados retornados
                    document.getElementById('cep').value = cep;
                    document.getElementById('endereco').value = data.logradouro;
                    document.getElementById('bairro').value = data.bairro;
                    document.getElementById('cidade').value = data.localidade;
                    
                    // Foca no próximo campo a ser preenchido
                    document.getElementById('endereco').focus();
                })
                .catch(error => {
                    alert('Erro ao consultar o CEP. Tente novamente.');
                    document.getElementById('cep').value = '';
                });
        });
        
        // Formata o CEP enquanto digita
        document.getElementById('cep').addEventListener('input', function() {
            this.value = this.value.replace(/\D/g, '');
            if (this.value.length > 8) {
                this.value = this.value.substring(0, 8);
            }
        });
    </script>
</body>
</html>

<style>
    .form-container { max-width: 800px; margin: auto; }
    .form-container h2 {
        font-size: 1.2em;
        color: #333;
        border-bottom: 2px solid #f0f0f0;
        padding-bottom: 5px;
        margin-top: 25px;
        margin-bottom: 20px;
    }
    .form-container h2 i {
        margin-right: 8px;
        color: #337ab7;
    }
    .form-row { display: flex; flex-wrap: wrap; margin-left: -10px; margin-right: -10px; }
    .form-group { padding: 0 10px; margin-bottom: 15px; flex-grow: 1; }
    .col-md-2 { flex-basis: 16.66%; }
    .col-md-4 { flex-basis: 33.33%; }
    .col-md-6 { flex-basis: 50%; }
    .col-md-8 { flex-basis: 66.66%; }
    .col-md-12 { flex-basis: 100%; }
    .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
    .form-group input, .form-group select, .form-group textarea {
        width: 100%;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 4px;
        box-sizing: border-box;
    }
    .form-actions { text-align: right; margin-top: 20px; }
    .btn-primary, .btn-secondary {
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        color: white;
        text-decoration: none;
        cursor: pointer;
        font-weight: bold;
    }
    .btn-primary { background-color: #28a745; }
    .btn-secondary { background-color: #6c757d; }
</style>