<?php
// gabinete/src/views/employees/configuracoes.php

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../helpers/AuthHelper.php';

// Se quiser forçar login, troque para: AuthHelper::requireLogin();
AuthHelper::check();

$pageTitle = "Configurações RH";
$nome = $_SESSION['nome'] ?? 'Usuário';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle) ?></title>

  <!-- Bootstrap 5 + Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body { background: #f5f7fb; }
    .page-hero {
      /* Cor padrão do sistema - Ajuste conforme necessário */
      background: linear-gradient(135deg, #0B1F3A, #102B54);
      color: #fff;
      border-bottom-left-radius: 24px;
      border-bottom-right-radius: 24px;
    }
    .page-hero .title {
      font-weight: 700;
      letter-spacing: .2px;
    }
    .card {
      border-radius: 12px;
      box-shadow: 0 4px 16px rgba(0,0,0,.06);
    }
    .btn-soft {
      border-radius: 12px;
      font-weight: 600;
      padding: .6rem 1rem;
    }
    .nav-pills .nav-link {
      border-radius: 10px;
      padding: .75rem 1.25rem;
      margin-bottom: .5rem;
    }
    .nav-pills .nav-link.active {
      background-color: #4f46e5;
    }
  </style>
</head>
<body>

  <!-- HERO -->
  <section class="page-hero py-5">
    <div class="container">
      <div class="d-flex justify-content-between align-items-start align-items-md-center flex-column flex-md-row gap-3">
        <div class="text-white">
          <h1 class="title h2 mb-2">
            <i class="bi bi-sliders2-vertical me-2"></i><?= htmlspecialchars($pageTitle) ?>
          </h1>
          <p class="mb-0 text-white-50">Personalize as configurações do módulo RH</p>
        </div>
        <div class="d-flex gap-2">
          <a href="<?= BASE_URL ?>/employees" class="btn btn-light btn-soft">
            <i class="bi bi-arrow-left me-2"></i>Voltar
          </a>
          <button class="btn btn-success btn-soft" id="saveBtn">
            <i class="bi bi-save me-2"></i>Salvar Alterações
          </button>
        </div>
      </div>
    </div>
  </section>

  <!-- CONTEÚDO -->
  <main class="container py-4 py-md-5">
    <div class="row g-4">
      <!-- Menu lateral -->
      <div class="col-md-3">
        <div class="card">
          <div class="card-body">
            <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist">
              <button class="nav-link active" id="v-pills-geral-tab" data-bs-toggle="pill" data-bs-target="#v-pills-geral" type="button" role="tab">
                <i class="bi bi-gear me-2"></i>Geral
              </button>
              <button class="nav-link" id="v-pills-cargos-tab" data-bs-toggle="pill" data-bs-target="#v-pills-cargos" type="button" role="tab">
                <i class="bi bi-briefcase me-2"></i>Cargos e Funções
              </button>
              <button class="nav-link" id="v-pills-departamentos-tab" data-bs-toggle="pill" data-bs-target="#v-pills-departamentos" type="button" role="tab">
                <i class="bi bi-building me-2"></i>Departamentos
              </button>
              <button class="nav-link" id="v-pills-permissoes-tab" data-bs-toggle="pill" data-bs-target="#v-pills-permissoes" type="button" role="tab">
                <i class="bi bi-shield-lock me-2"></i>Permissões
              </button>
              <button class="nav-link" id="v-pills-integracoes-tab" data-bs-toggle="pill" data-bs-target="#v-pills-integracoes" type="button" role="tab">
                <i class="bi bi-link-45deg me-2"></i>Integrações
              </button>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Conteúdo das abas -->
      <div class="col-md-9">
        <div class="card">
          <div class="card-body">
            <div class="tab-content" id="v-pills-tabContent">
              <!-- Aba Geral -->
              <div class="tab-pane fade show active" id="v-pills-geral" role="tabpanel">
                <h4 class="mb-4">Configurações Gerais</h4>
                <form>
                  <div class="mb-3">
                    <label class="form-label">Nome da Empresa</label>
                    <input type="text" class="form-control" value="Gabinete Digital">
                  </div>
                  <div class="mb-3">
                    <label class="form-label">CNPJ</label>
                    <input type="text" class="form-control" value="00.000.000/0001-00">
                  </div>
                  <div class="mb-3">
                    <label class="form-label">E-mail para Notificações</label>
                    <input type="email" class="form-control" value="rh@gabinete.com">
                  </div>
                  <div class="mb-3 form-check">
                    <input type="checkbox" class="form-check-input" id="notificacoes" checked>
                    <label class="form-check-label" for="notificacoes">Ativar notificações por e-mail</label>
                  </div>
                </form>
              </div>
              
              <!-- Aba Cargos -->
              <div class="tab-pane fade" id="v-pills-cargos" role="tabpanel">
                <div class="d-flex justify-content-between align-items-center mb-4">
                  <h4 class="mb-0">Cargos e Funções</h4>
                  <button class="btn btn-sm btn-primary">
                    <i class="bi bi-plus-lg me-2"></i>Novo Cargo
                  </button>
                </div>
                <table class="table">
                  <thead>
                    <tr>
                      <th>Cargo</th>
                      <th>Departamento</th>
                      <th>Ações</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td>Analista de RH</td>
                      <td>Recursos Humanos</td>
                      <td>
                        <div class="btn-group btn-group-sm">
                          <button class="btn btn-outline-secondary"><i class="bi bi-pencil"></i></button>
                          <button class="btn btn-outline-danger"><i class="bi bi-trash"></i></button>
                        </div>
                      </td>
                    </tr>
                    <tr>
                      <td>Desenvolvedor</td>
                      <td>TI</td>
                      <td>
                        <div class="btn-group btn-group-sm">
                          <button class="btn btn-outline-secondary"><i class="bi bi-pencil"></i></button>
                          <button class="btn btn-outline-danger"><i class="bi bi-trash"></i></button>
                        </div>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
              
              <!-- Outras abas -->
              <div class="tab-pane fade" id="v-pills-departamentos" role="tabpanel">
                <h4 class="mb-4">Departamentos</h4>
                <p>Configure os departamentos da empresa.</p>
              </div>
              
              <div class="tab-pane fade" id="v-pills-permissoes" role="tabpanel">
                <h4 class="mb-4">Permissões</h4>
                <p>Configure as permissões de acesso ao módulo RH.</p>
              </div>
              
              <div class="tab-pane fade" id="v-pills-integracoes" role="tabpanel">
                <h4 class="mb-4">Integrações</h4>
                <p>Configure integrações com outros sistemas.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Exemplo de script para salvar configurações
    document.getElementById('saveBtn').addEventListener('click', function() {
      // Simulação de salvamento
      alert('Configurações salvas com sucesso!');
    });
  </script>
</body>
</html>