<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../partials/header.php';

// URL da foto atual para prévia
$photoUrl = $employee['_photo_url'] ?? (
    !empty($employee['photo_path'])
        ? BASE_URL . '/' . ltrim($employee['photo_path'], '/')
        : BASE_URL . '/assets/img/placeholder-user.png'
);
?>
<div class="container py-4" style="max-width:780px;">
  <div class="card border-light mb-3">
    <div class="card-body">
      <div class="d-flex align-items-start justify-content-between mb-3">
        <div>
          <h4 class="mb-0">Editar Colaborador</h4>
          <p class="text-muted small mb-0">Atualize as informações do colaborador.</p>
        </div>
        <a href="<?= BASE_URL ?>/employees" class="btn btn-sm btn-outline-secondary">Voltar</a>
      </div>

      <?php if (!empty($_SESSION['errors'])): ?>
        <div class="alert alert-danger small">
          <strong>Corrija os erros:</strong>
          <ul class="mb-0 mt-1">
            <?php foreach ($_SESSION['errors'] as $err): ?><li><?= htmlspecialchars($err) ?></li><?php endforeach; ?>
          </ul>
        </div>
        <?php unset($_SESSION['errors']); ?>
      <?php endif; ?>

      <form method="POST" action="<?= BASE_URL ?>/employees/<?= (int)$employee['id'] ?>/update" enctype="multipart/form-data">
        <div class="row g-2">
          <div class="col-12 col-md-8">
            <div class="mb-2">
              <label class="form-label small">Nome completo *</label>
              <input type="text" name="full_name" class="form-control form-control-sm" required value="<?= htmlspecialchars($_SESSION['old']['full_name'] ?? $employee['full_name']) ?>">
            </div>

            <div class="row">
              <div class="col-6">
                <label class="form-label small">CPF *</label>
                <input type="text" id="cpf" name="cpf" class="form-control form-control-sm" required value="<?= htmlspecialchars($_SESSION['old']['cpf'] ?? $employee['cpf']) ?>">
              </div>
              <div class="col-6">
                <label class="form-label small">Telefone</label>
                <input type="text" id="phone_number" name="phone_number" class="form-control form-control-sm" value="<?= htmlspecialchars($_SESSION['old']['phone_number'] ?? $employee['phone_number']) ?>">
              </div>
            </div>

            <div class="mt-2">
              <label class="form-label small">Endereço</label>
              <input type="text" name="address" class="form-control form-control-sm" value="<?= htmlspecialchars($_SESSION['old']['address'] ?? $employee['address']) ?>">
            </div>

            <hr>

            <div class="row g-2">
              <div class="col-6">
                <label class="form-label small">Cargo *</label>
                <input type="text" name="job_title" class="form-control form-control-sm" required value="<?= htmlspecialchars($_SESSION['old']['job_title'] ?? $employee['job_title']) ?>">
              </div>
              <div class="col-6">
                <label class="form-label small">Salário</label>
                <input type="text" id="salary" name="salary" class="form-control form-control-sm" value="<?= htmlspecialchars($_SESSION['old']['salary'] ?? ($employee['salary'] ?? '')) ?>">
              </div>
            </div>

            <div class="row g-2 mt-2">
              <div class="col-6">
                <label class="form-label small">Tipo de contrato</label>
                <?php $ct = $_SESSION['old']['contract_type'] ?? $employee['contract_type']; ?>
                <select name="contract_type" class="form-select form-select-sm">
                  <?php foreach (['CLT','PJ','Estagiário','Terceirizado'] as $opt): ?>
                    <option value="<?= $opt ?>" <?= ($ct === $opt ? 'selected' : '') ?>><?= $opt ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-6">
                <label class="form-label small">Status</label>
                <?php $st = $_SESSION['old']['status'] ?? $employee['status']; ?>
                <select name="status" class="form-select form-select-sm">
                  <option value="ativo" <?= ($st === 'ativo' ? 'selected' : '') ?>>Ativo</option>
                  <option value="inativo" <?= ($st === 'inativo' ? 'selected' : '') ?>>Inativo</option>
                  <option value="demitido" <?= ($st === 'demitido' ? 'selected' : '') ?>>Demitido</option>
                </select>
              </div>
            </div>
          </div>

          <div class="col-12 col-md-4">
            <label class="form-label small">Foto</label>
            <input type="file" id="photo" name="photo" accept="image/*" class="form-control form-control-sm mb-2">
            <input type="hidden" name="current_photo_path" value="<?= htmlspecialchars($employee['photo_path'] ?? '') ?>">
            <img id="photoPreview" src="<?= $photoUrl ?>" alt="Prévia" class="employee-photo-preview mb-2">
            <?php if (!empty($employee['photo_path'])): ?>
              <div class="form-check">
                <input class="form-check-input" type="checkbox" name="remove_photo" value="1" id="chkRemovePhoto">
                <label class="form-check-label small" for="chkRemovePhoto">Remover foto atual</label>
              </div>
            <?php endif; ?>
          </div>
        </div>

        <div class="d-flex justify-content-end mt-3">
          <a href="<?= BASE_URL ?>/employees/<?= (int)$employee['id'] ?>" class="btn btn-sm btn-outline-secondary me-2">Cancelar</a>
          <button type="submit" class="btn btn-sm btn-primary">Salvar alterações</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php unset($_SESSION['old']); require_once __DIR__ . '/../partials/footer.php';

?>
