<div class="content-box">
    <h1><i class="fas fa-user-shield"></i> Painel Administrativo</h1>
    <p>Área restrita para administradores do sistema.</p>

    <?php if (isset($_SESSION['success_message'])): ?>
        <div class="alert alert-success">
            <?= $_SESSION['success_message'] ?>
            <?php unset($_SESSION['success_message']); ?>
        </div>
    <?php endif; ?>

    <?php if (isset($_SESSION['error_message'])): ?>
        <div class="alert alert-danger">
            <?= $_SESSION['error_message'] ?>
            <?php unset($_SESSION['error_message']); ?>
        </div>
    <?php endif; ?>

    <div class="admin-dashboard">
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-info">
                    <h3><?= $dados['totalUsuarios'] ?></h3>
                    <p>Usuários Ativos</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-user-friends"></i>
                </div>
                <div class="stat-info">
                    <h3><?= $dados['totalEleitores'] ?></h3>
                    <p>Eleitores Cadastrados</p>
                </div>
            </div>

            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-file-alt"></i>
                </div>
                <div class="stat-info">
                    <h3><?= $dados['totalDocumentos'] ?></h3>
                    <p>Documentos Armazenados</p>
                </div>
            </div>
        </div>

        <div class="admin-actions">
            <h2>Ações Administrativas</h2>
            <div class="action-buttons">
                <a href="<?= BASE_URL ?>/paineladmin/usuarios" class="btn btn-primary">
                    <i class="fas fa-users-cog"></i> Gerenciar Usuários
                </a>
                <a href="<?= BASE_URL ?>/paineladmin/criarUsuario" class="btn btn-success">
                    <i class="fas fa-user-plus"></i> Criar Novo Usuário
                </a>
                <a href="<?= BASE_URL ?>/paineladmin/niveisAcesso" class="btn btn-warning">
                    <i class="fas fa-shield-alt"></i> Níveis de Acesso
                </a>
                <a href="<?= BASE_URL ?>/relatorios" class="btn btn-info">
                    <i class="fas fa-chart-bar"></i> Ver Relatórios
                </a>
            </div>
        </div>

        <?php if (!empty($dados['usuariosRecentes'])): ?>
        <div class="recent-users">
            <h2>Usuários Recentes</h2>
            <table>
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Email</th>
                        <th>Nível</th>
                        <th>Data de Criação</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($dados['usuariosRecentes'] as $usuario): ?>
                    <tr>
                        <td><?= htmlspecialchars($usuario['nome']) ?></td>
                        <td><?= htmlspecialchars($usuario['email']) ?></td>
                        <td>
                            <span class="badge badge-<?= strtolower($usuario['nivel_acesso']) ?>">
                                <?= $usuario['nivel_acesso'] ?>
                            </span>
                        </td>
                        <td><?= date('d/m/Y H:i', strtotime($usuario['data_criacao'])) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
    </div>
</div>

<style>
.admin-dashboard {
    max-width: 1200px;
    margin: 0 auto;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.stat-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 25px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.stat-icon {
    font-size: 3em;
    margin-right: 20px;
    opacity: 0.8;
}

.stat-info h3 {
    font-size: 2.5em;
    margin: 0;
    font-weight: bold;
}

.stat-info p {
    margin: 5px 0 0 0;
    opacity: 0.9;
}

.admin-actions {
    background: white;
    padding: 25px;
    border-radius: 8px;
    margin-bottom: 30px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.action-buttons {
    display: flex;
    gap: 15px;
    flex-wrap: wrap;
}

.btn {
    padding: 12px 20px;
    border: none;
    border-radius: 5px;
    text-decoration: none;
    font-weight: bold;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s;
}

.btn-primary { background-color: #3498db; color: white; }
.btn-success { background-color: #27ae60; color: white; }
.btn-info { background-color: #17a2b8; color: white; }

.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.recent-users {
    background: white;
    padding: 25px;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.badge {
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 0.8em;
    font-weight: bold;
}

.badge-admin { background-color: #e74c3c; color: white; }
.badge-assessor { background-color: #f39c12; color: white; }
.badge-estagiario { background-color: #95a5a6; color: white; }

.alert {
    padding: 15px;
    margin-bottom: 20px;
    border: 1px solid transparent;
    border-radius: 4px;
}

.alert-success {
    color: #155724;
    background-color: #d4edda;
    border-color: #c3e6cb;
}

.alert-danger {
    color: #721c24;
    background-color: #f8d7da;
    border-color: #f5c6cb;
}
</style>
