<?php
// debug_sql.php
require_once __DIR__ . '/src/config/config.php';

try {
    $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    echo "<h3>Verificando Colunas:</h3>";
    $stmt = $pdo->query("DESCRIBE eleitores");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($columns as $col) {
        echo $col['Field'] . " (" . $col['Type'] . ")<br>";
    }

    echo "<h3>Testando Consulta:</h3>";
    $sql = "SELECT u.nome, DATE(e.data_cadastro) as data, COUNT(e.id) as quantidade 
            FROM eleitores e 
            JOIN usuarios u ON e.usuario_id = u.id 
            GROUP BY u.nome, DATE(e.data_cadastro) 
            ORDER BY data DESC, u.nome ASC";

    echo "<pre>" . $sql . "</pre>";

    $stmt = $pdo->query($sql);
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "<h3>Resultados (" . count($results) . "):</h3>";
    echo "<pre>";
    print_r($results);
    echo "</pre>";

} catch (PDOException $e) {
    echo "<h3>ERRO SQL:</h3>";
    echo $e->getMessage();
}
