<?php
require_once __DIR__ . '/src/config/config.php';

try {
    $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    echo "Distinct types in eleitores table:\n";
    $stmt = $pdo->query("SELECT DISTINCT tipo FROM eleitores");
    $types = $stmt->fetchAll(PDO::FETCH_COLUMN);
    foreach ($types as $type) {
        echo "- '" . $type . "'\n";
    }

    echo "\nChecking for 'Liderança' (exact match):\n";
    $stmt = $pdo->query("SELECT COUNT(*) FROM eleitores WHERE tipo = 'Liderança'");
    echo "Count: " . $stmt->fetchColumn() . "\n";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
