-- Script para criar sistema de níveis de acesso
-- Atualiza a tabela usuarios para usar os novos níveis de acesso

-- Primeiro, vamos alterar o enum da tabela usuarios para incluir os novos níveis
ALTER TABLE `usuarios` 
MODIFY COLUMN `nivel_acesso` ENUM(
    'Admin',
    'Agenda_Financeiro_Documentos',
    'Eleitor_Documentos', 
    'Documentos_Financeiro_RH',
    'Acesso_Total'
) NOT NULL DEFAULT 'Eleitor_Documentos';

-- Criar tabela de permissões para mapear módulos por nível de acesso
CREATE TABLE IF NOT EXISTS `niveis_acesso_permissoes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nivel_acesso` varchar(50) NOT NULL,
  `modulo` varchar(50) NOT NULL,
  `pode_visualizar` tinyint(1) DEFAULT 1,
  `pode_criar` tinyint(1) DEFAULT 0,
  `pode_editar` tinyint(1) DEFAULT 0,
  `pode_excluir` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nivel_modulo` (`nivel_acesso`, `modulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Inserir permissões para cada nível de acesso

-- Nível: Agenda_Financeiro_Documentos (acesso somente agenda, financeiro e documentos)
INSERT INTO `niveis_acesso_permissoes` (`nivel_acesso`, `modulo`, `pode_visualizar`, `pode_criar`, `pode_editar`, `pode_excluir`) VALUES
('Agenda_Financeiro_Documentos', 'agendas', 1, 1, 1, 1),
('Agenda_Financeiro_Documentos', 'documentos', 1, 1, 1, 1),
('Agenda_Financeiro_Documentos', 'contas', 1, 1, 1, 1),
('Agenda_Financeiro_Documentos', 'eleitores', 0, 0, 0, 0),
('Agenda_Financeiro_Documentos', 'rh', 0, 0, 0, 0),
('Agenda_Financeiro_Documentos', 'material_publicitario', 0, 0, 0, 0),
('Agenda_Financeiro_Documentos', 'relatorios', 0, 0, 0, 0);

-- Nível: Eleitor_Documentos (acesso somente eleitor e documentos)
INSERT INTO `niveis_acesso_permissoes` (`nivel_acesso`, `modulo`, `pode_visualizar`, `pode_criar`, `pode_editar`, `pode_excluir`) VALUES
('Eleitor_Documentos', 'eleitores', 1, 1, 1, 1),
('Eleitor_Documentos', 'documentos', 1, 1, 1, 1),
('Eleitor_Documentos', 'agendas', 0, 0, 0, 0),
('Eleitor_Documentos', 'contas', 0, 0, 0, 0),
('Eleitor_Documentos', 'rh', 0, 0, 0, 0),
('Eleitor_Documentos', 'material_publicitario', 0, 0, 0, 0),
('Eleitor_Documentos', 'relatorios', 0, 0, 0, 0);

-- Nível: Documentos_Financeiro_RH (acesso documentos, financeiro e rh)
INSERT INTO `niveis_acesso_permissoes` (`nivel_acesso`, `modulo`, `pode_visualizar`, `pode_criar`, `pode_editar`, `pode_excluir`) VALUES
('Documentos_Financeiro_RH', 'documentos', 1, 1, 1, 1),
('Documentos_Financeiro_RH', 'contas', 1, 1, 1, 1),
('Documentos_Financeiro_RH', 'rh', 1, 1, 1, 1),
('Documentos_Financeiro_RH', 'agendas', 0, 0, 0, 0),
('Documentos_Financeiro_RH', 'eleitores', 0, 0, 0, 0),
('Documentos_Financeiro_RH', 'material_publicitario', 0, 0, 0, 0),
('Documentos_Financeiro_RH', 'relatorios', 0, 0, 0, 0);

-- Nível: Acesso_Total (acesso a tudo)
INSERT INTO `niveis_acesso_permissoes` (`nivel_acesso`, `modulo`, `pode_visualizar`, `pode_criar`, `pode_editar`, `pode_excluir`) VALUES
('Acesso_Total', 'agendas', 1, 1, 1, 1),
('Acesso_Total', 'documentos', 1, 1, 1, 1),
('Acesso_Total', 'eleitores', 1, 1, 1, 1),
('Acesso_Total', 'contas', 1, 1, 1, 1),
('Acesso_Total', 'rh', 1, 1, 1, 1),
('Acesso_Total', 'material_publicitario', 1, 1, 1, 1),
('Acesso_Total', 'relatorios', 1, 1, 1, 1);

-- Nível: Admin (acesso total + administração)
INSERT INTO `niveis_acesso_permissoes` (`nivel_acesso`, `modulo`, `pode_visualizar`, `pode_criar`, `pode_editar`, `pode_excluir`) VALUES
('Admin', 'agendas', 1, 1, 1, 1),
('Admin', 'documentos', 1, 1, 1, 1),
('Admin', 'eleitores', 1, 1, 1, 1),
('Admin', 'contas', 1, 1, 1, 1),
('Admin', 'rh', 1, 1, 1, 1),
('Admin', 'material_publicitario', 1, 1, 1, 1),
('Admin', 'relatorios', 1, 1, 1, 1),
('Admin', 'admin', 1, 1, 1, 1),
('Admin', 'configuracoes', 1, 1, 1, 1);