<?php
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
// Carrega configurações
require_once __DIR__ . '/../../../src/config/config.php';
$BASE_PATH = rtrim(BASE_URL, '/');
if (empty($_SESSION['user_id'])) {
  header('Location: ' . $BASE_PATH . '/login.php', true, 302);
  exit;
}

/**
 * Seu módulo já tem um calendário completo em calendario.php.
 * Para não quebrar nada, apenas encaminhamos pra ele.
 * Se quiser outras rotas no futuro, adicione ao array.
 */
$routes = array(
  'calendario' => $BASE_PATH . '/src/controllers/AgendasController.php',
);

$p = isset($_GET['p']) ? strtolower(preg_replace('/[^a-z0-9_]/i', '', $_GET['p'])) : 'calendario';

// Se for calendário, incluímos o controller que vai carregar a view
if ($p === 'calendario') {
  require_once __DIR__ . '/../../controllers/AgendasController.php';
  // O controller já instancia e chama index() no final do arquivo ou podemos chamar aqui se mudarmos o controller
  // O controller atual tem "new AgendasController();" no final, que chama index() no construtor se action não for definida
  // Mas precisamos garantir que $_GET['action'] esteja vazio ou 'index' para carregar a view
  if (!isset($_GET['action'])) {
    $_GET['action'] = 'index';
  }
} else {
  // Fallback ou outras rotas
  $destino = isset($routes[$p]) ? $routes[$p] : $routes['calendario'];
  header('Location: ' . $destino, true, 302);
  exit;
}
