<?php
// Inclui o model de usuário para verificar o status da conexão
require_once __DIR__ . '/../../models/Usuario.php';
$usuarioModel = new Usuario();
// Verifica se o usuário logado já tem um token salvo
$token = $usuarioModel->getTokenGoogle($_SESSION['usuario_id']);
$estaConectado = !empty($token);
?>

<div class="content-box">
    <h1>Configurações</h1>
    <p>Gerencie as configurações da sua conta e integrações externas.</p>

    <hr>

    <h2>Integrações</h2>
    <p>Conecte sua conta Google para integrar seus agendamentos com a Google Agenda.</p>

    <?php
    // Verifica se há uma mensagem de status na URL (enviada pelo GoogleController)
    if (isset($_GET['status'])):
        if ($_GET['status'] == 'google_success'):
    ?>
        <div class="alert alert-success">
            <strong>Sucesso!</strong> Sua conta Google foi conectada.
        </div>
    <?php elseif ($_GET['status'] == 'google_error'): ?>
        <div class="alert alert-danger">
            <strong>Erro!</strong> Não foi possível conectar com a sua conta Google. Tente novamente.
        </div>
    <?php elseif ($_GET['status'] == 'google_not_configured'): ?>
        <div class="alert alert-warning">
            <strong>Google não configurado!</strong> A integração com o Google Calendar não está disponível. 
            Para ativar esta funcionalidade, é necessário:
            <ul style="margin-top: 10px;">
                <li>Instalar as dependências do Google (execute <code>composer install</code>)</li>
                <li>Configurar as credenciais do Google no arquivo de configuração</li>
            </ul>
        </div>
    <?php 
        endif;
    endif; 
    ?>

    <?php if ($estaConectado): ?>
        <div class="alert alert-info">
            <p><strong>Status:</strong> Conectado à Agenda Google.</p>
            <p>Você já pode criar agendamentos que serão sincronizados automaticamente.</p>
            <!-- Futuramente, você pode adicionar um botão para desconectar -->
        </div>
    <?php else: ?>
        <!-- ESTE É O BOTÃO DO CANVAS, INTEGRADO NO LUGAR CERTO -->
        <a href="<?= BASE_URL ?>/google/auth" class="button-primary">
            Conectar com a Agenda Google
        </a>
    <?php endif; ?>

    <hr>

    <h2>Notificações WhatsApp</h2>
    <p>Configure notificações automáticas por WhatsApp para seus compromissos.</p>
    
    <?php if ($_SESSION['nivel_acesso'] === 'Admin'): ?>
        <a href="<?= BASE_URL ?>/configuracoes/whatsapp" class="button-whatsapp">
            🔧 Configurar WhatsApp
        </a>
        <p class="config-description">Configure as credenciais da API, templates de mensagem e horários de envio.</p>
    <?php else: ?>
        <div class="alert alert-info">
            <p><strong>Acesso Restrito:</strong> Apenas administradores podem configurar as notificações WhatsApp.</p>
            <p>Entre em contato com o administrador do sistema para ativar esta funcionalidade.</p>
        </div>
    <?php endif; ?>

</div>

<!-- Estilos para o botão e para os alertas -->
<style>
    .button-primary {
        display: inline-block;
        padding: 10px 20px;
        background-color: #4285F4; /* Cor do Google */
        color: white;
        text-decoration: none;
        border-radius: 5px;
        font-weight: bold;
        border: none;
        cursor: pointer;
        font-size: 16px;
    }
    .button-primary:hover {
        background-color: #357ae8;
    }
    .button-whatsapp {
        display: inline-block;
        padding: 10px 20px;
        background-color: #25D366; /* Cor do WhatsApp */
        color: white;
        text-decoration: none;
        border-radius: 5px;
        font-weight: bold;
        border: none;
        cursor: pointer;
        font-size: 16px;
        margin-bottom: 10px;
    }
    .button-whatsapp:hover {
        background-color: #1ebe57;
    }
    .config-description {
        color: #666;
        font-size: 14px;
        margin-top: 5px;
    }
    .alert {
        padding: 15px;
        margin-bottom: 20px;
        border: 1px solid transparent;
        border-radius: 4px;
    }
    .alert-success {
        color: #155724;
        background-color: #d4edda;
        border-color: #c3e6cb;
    }
    .alert-danger {
        color: #721c24;
        background-color: #f8d7da;
        border-color: #f5c6cb;
    }
    .alert-info {
        color: #0c5460;
        background-color: #d1ecf1;
        border-color: #bee5eb;
    }
</style>
