<?php
// src/views/partials/header.php
if (session_status() === PHP_SESSION_NONE)
  session_start();

// Traz config (BASE_URL, etc.)
$cfg = dirname(__DIR__, 2) . '/config/config.php';
if (file_exists($cfg))
  require_once $cfg;

// Fallback do BASE_URL se alguém abrir view direto
if (!defined('BASE_URL')) {
  // ex.: /src/views/employees/colaboradores.php
  $guess = preg_replace('#/src/.*$#', '', $_SERVER['SCRIPT_NAME'] ?? '');
  define('BASE_URL', rtrim($guess, '/'));
}

// Para todas as URLs relativas funcionarem mesmo ao abrir views direto:
$BASE = BASE_URL;
?><!doctype html>
<html lang="pt-br">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Faz todos os links relativos partirem do BASE_URL -->
  <base href="<?= htmlspecialchars($BASE) ?>/">

  <title>Sistema de Gestão de Gabinete</title>

  <link rel="icon" href="public/images/favicon.png" type="image/png">

  <!-- Bootstrap sempre disponível (mesmo sem build local) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Seu CSS (opcional): coloque em /gabinete/assets/css/app.css -->
  <link rel="stylesheet" href="assets/css/app.css">
  <style>
    /* Tema padrão para RH (compatível com rh/index.php)
       Variáveis permitem sobrescrever em views específicas se necessário. */
    :root {
      --rh-primary: #0B1F3A;
      --rh-secondary: #102B54;
      --rh-accent: #3B82F6;
    }

    .employee-photo-preview {
      width: 80px;
      height: 80px;
      object-fit: cover;
      border-radius: 8px;
    }

    .navbar-brand .brand-icon,
    .navbar .bi {
      font-size: 1rem;
      line-height: 1;
      vertical-align: middle;
      display: inline-block;
    }

    .navbar-rh {
      background: linear-gradient(135deg, var(--rh-primary), var(--rh-secondary));
    }

    body {
      background-color: #f8fafc;
      color: #334155;
    }
  </style>
</head>

<body>
  <!-- Navbar estilo RH (gradiente) -->
  <!-- Navbar Genérica -->
  <nav class="navbar navbar-expand-lg navbar-rh navbar-dark">
    <div class="container">
      <a class="navbar-brand d-flex align-items-center"
        href="<?= rtrim(BASE_URL, '/') ?>/src/views/dashboard/index.php">
        <i class="bi bi-grid-fill me-2"></i>
        <span>Painel</span>
      </a>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbarMain">
        <ul class="navbar-nav me-auto mb-2 mb-lg-0">
          <li class="nav-item">
            <a class="nav-link active" href="<?= rtrim(BASE_URL, '/') ?>/src/views/dashboard/index.php">Início</a>
          </li>
          <!-- Adicione outros links aqui se desejar um menu fixo -->
        </ul>

        <div class="d-flex align-items-center gap-2">
          <?php $nome = $_SESSION['nome'] ?? null; ?>
          <?php if ($nome): ?><span class="text-white small me-2">Olá,
              <?= htmlspecialchars($nome) ?></span><?php endif; ?>
          <a class="btn btn-outline-light btn-sm" href="<?= rtrim(BASE_URL, '/') ?>/logout.php">Sair</a>
        </div>
      </div>
    </div>
  </nav>