<?php
// O controller disponibiliza a variável $liderancas
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap"
        rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8fafc;
        }

        .card-container {
            background-color: #ffffff;
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
            margin-top: 2rem;
        }

        @media print {
            .no-print {
                display: none !important;
            }

            .card-container {
                box-shadow: none;
                margin-top: 0;
            }
        }
    </style>
</head>

<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary no-print">
        <div class="container-fluid">
            <span class="navbar-brand">
                <i class="bi bi-people-fill me-2"></i>
                <?= htmlspecialchars($pageTitle) ?>
            </span>
            <div>
                <button onclick="window.print()" class="btn btn-light btn-sm me-2">
                    <i class="bi bi-printer-fill"></i> Imprimir
                </button>
                <a href="<?= BASE_URL ?>/src/views/relatorios/" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>
    </nav>

    <div class="container py-4">
        <div class="card-container">
            <h4 class="mb-4">Lideranças Cadastradas</h4>

            <?php if (isset($liderancas['error'])): ?>
                <div class="alert alert-danger">
                    <?= htmlspecialchars($liderancas['error']) ?>
                </div>
            <?php elseif (empty($liderancas)): ?>
                <div class="alert alert-info">Nenhuma liderança encontrada.</div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead class="table-light">
                            <tr>
                                <th>Nome</th>
                                <th>Telefone</th>
                                <th>Bairro</th>
                                <th>Cidade</th>
                                <th>Tipo</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($liderancas as $lider): ?>
                                <tr>
                                    <td><?= htmlspecialchars($lider['nome']) ?></td>
                                    <td><?= htmlspecialchars($lider['telefone'] ?? 'Não informado') ?></td>
                                    <td><?= htmlspecialchars($lider['bairro'] ?? 'Não informado') ?></td>
                                    <td><?= htmlspecialchars($lider['cidade'] ?? 'Não informado') ?></td>
                                    <td><span class="badge bg-success"><?= htmlspecialchars($lider['tipo']) ?></span></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>

</html>