-- Cria tabela de configurações do sistema
USE `gabinete_bd`;

CREATE TABLE IF NOT EXISTS `configuracoes_sistema` (
  `id` int NOT NULL AUTO_INCREMENT,
  `chave` varchar(100) NOT NULL UNIQUE,
  `valor` text,
  `descricao` varchar(255),
  `tipo` enum('texto','numero','boolean','select') DEFAULT 'texto',
  `opcoes` text COMMENT 'Para tipo select, JSON com opções',
  `data_criacao` timestamp DEFAULT CURRENT_TIMESTAMP,
  `data_atualizacao` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Insere configurações padrão do WhatsApp
INSERT INTO `configuracoes_sistema` (`chave`, `valor`, `descricao`, `tipo`) VALUES
('whatsapp_ativo', '0', 'Ativar notificações WhatsApp', 'boolean'),
('whatsapp_api_provider', 'twilio', 'Provedor da API WhatsApp', 'select'),
('whatsapp_template_compromisso', 'Olá! Lembrete do seu compromisso: {titulo} em {data} às {hora}. Gabinete Municipal.', 'Template da mensagem de lembrete', 'texto'),
('whatsapp_antecedencia_horas', '2', 'Horas de antecedência para envio', 'numero'),
('whatsapp_horario_inicio', '08:00', 'Horário de início para envio', 'texto'),
('whatsapp_horario_fim', '20:00', 'Horário limite para envio', 'texto');