<?php
require_once __DIR__ . '/../models/Agenda.php';
require_once __DIR__ . '/../models/Eleitor.php';
require_once __DIR__ . '/../models/Usuario.php'; // Adicionado para buscar o token do Google
require_once __DIR__ . '/../helpers/AuthHelper.php';

// CORRIGIDO: A linha abaixo foi comentada para evitar o erro, pois a biblioteca do Google não foi instalada via Composer.
// require_once __DIR__ . '/../../vendor/autoload.php';

class AgendasController {

    /**
     * Ação principal: Exibe a página com o calendário.
     */
    public function index() {
        AuthHelper::check(); 
        $pageTitle = "Agenda de Compromissos";

        $eleitorModel = new Eleitor();
        $eleitores = $eleitorModel->getAll();

        require_once __DIR__ . '/../views/partials/header.php';
        require_once __DIR__ . '/../views/agendas/calendario.php'; 
        require_once __DIR__ . '/../views/partials/footer.php';
    }

    /**
     * Fornece os eventos em formato JSON para o FullCalendar.
     */
    public function getEventosJson() {
        AuthHelper::check();
        $start = $_GET['start'] ?? date('Y-m-01');
        $end = $_GET['end'] ?? date('Y-m-t');
        $agendaModel = new Agenda();
        $eventos = $agendaModel->getAgendasPorIntervalo($start, $end);
        header('Content-Type: application/json');
        echo json_encode($eventos);
        exit();
    }
    
    public function store() {
        AuthHelper::check();
        header('Content-Type: application/json');

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $dados = [
                'titulo' => $_POST['titulo'],
                'data_inicio' => $_POST['data_inicio'],
                'data_fim' => !empty($_POST['data_fim']) ? $_POST['data_fim'] : null,
                'id_eleitor' => !empty($_POST['id_eleitor']) ? $_POST['id_eleitor'] : null,
                'categoria' => $_POST['categoria'],
                'descricao' => $_POST['descricao'] ?? '',
                'id_responsavel' => $_SESSION['usuario_id'],
                'whatsapp_notificacao' => isset($_POST['whatsapp_notificacao']) ? 1 : 0
            ];

            $agendaModel = new Agenda();
            $novoId = $agendaModel->create($dados);

            if ($novoId) {
                // CORRIGIDO: A sincronização com o Google foi desativada temporariamente para evitar o erro.
                // $this->sincronizarComGoogleAgenda($novoId, $dados);
                
                echo json_encode(['status' => 'success', 'message' => 'Agendamento criado localmente!', 'id' => $novoId]);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Falha ao criar agendamento.']);
            }
            exit();
        }
    }

    /**
     * Busca um agendamento específico pelo ID
     */
    public function getAgendamento() {
        AuthHelper::check();
        header('Content-Type: application/json');
        
        if (!isset($_GET['id'])) {
            echo json_encode(['status' => 'error', 'message' => 'ID do agendamento não fornecido']);
            exit();
        }
        
        $agendaModel = new Agenda();
        $agendamento = $agendaModel->getById($_GET['id']);
        
        if ($agendamento) {
            echo json_encode(['status' => 'success', 'data' => $agendamento]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Agendamento não encontrado']);
        }
        exit();
    }
    
    /**
     * Atualiza um agendamento existente
     */
    public function update() {
        AuthHelper::check();
        header('Content-Type: application/json');
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (!isset($_POST['id'])) {
                echo json_encode(['status' => 'error', 'message' => 'ID do agendamento não fornecido']);
                exit();
            }
            
            $dados = [
                'titulo' => $_POST['titulo'],
                'data_inicio' => $_POST['data_inicio'],
                'data_fim' => !empty($_POST['data_fim']) ? $_POST['data_fim'] : null,
                'id_eleitor' => !empty($_POST['id_eleitor']) ? $_POST['id_eleitor'] : null,
                'categoria' => $_POST['categoria'],
                'descricao' => $_POST['descricao'] ?? '',
                'whatsapp_notificacao' => isset($_POST['whatsapp_notificacao']) ? 1 : 0
            ];
            
            $agendaModel = new Agenda();
            $sucesso = $agendaModel->update($_POST['id'], $dados);
            
            if ($sucesso) {
                echo json_encode(['status' => 'success', 'message' => 'Agendamento atualizado com sucesso!']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Falha ao atualizar agendamento.']);
            }
            exit();
        }
    }
    
    /**
     * Exclui um agendamento
     */
    public function delete() {
        AuthHelper::check();
        header('Content-Type: application/json');
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (!isset($_POST['id'])) {
                echo json_encode(['status' => 'error', 'message' => 'ID do agendamento não fornecido']);
                exit();
            }
            
            $agendaModel = new Agenda();
            $sucesso = $agendaModel->delete($_POST['id']);
            
            if ($sucesso) {
                echo json_encode(['status' => 'success', 'message' => 'Agendamento excluído com sucesso!']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Falha ao excluir agendamento.']);
            }
            exit();
        }
    }

    /**
     * MÉTODO DESATIVADO TEMPORARIAMENTE: Tenta sincronizar o evento com a Agenda Google.
     * Para reativar, é necessário instalar a biblioteca do Google via Composer.
     */
    /*
    private function sincronizarComGoogleAgenda($id_agendamento, $dados_agendamento) {
        $usuarioModel = new Usuario();
        $tokenJson = $usuarioModel->getTokenGoogle($_SESSION['usuario_id']);

        if (!$tokenJson) {
            return;
        }

        $client = new Google_Client();
        $client->setClientId(GOOGLE_CLIENT_ID);
        $client->setClientSecret(GOOGLE_CLIENT_SECRET);
        $client->setAccessToken($tokenJson);

        if ($client->isAccessTokenExpired()) {
            $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
            $usuarioModel->salvarTokenGoogle($_SESSION['usuario_id'], json_encode($client->getAccessToken()));
        }

        $service = new Google_Service_Calendar($client);
        
        $event = new Google_Service_Calendar_Event([
            'summary' => $dados_agendamento['titulo'],
            'description' => $dados_agendamento['descricao'],
            'start' => [
                'dateTime' => date('c', strtotime($dados_agendamento['data_inicio'])),
                'timeZone' => 'America/Belem',
            ],
            'end' => [
                'dateTime' => date('c', strtotime($dados_agendamento['data_fim'] ?? $dados_agendamento['data_inicio'] . ' +1 hour')),
                'timeZone' => 'America/Belem',
            ],
        ]);

        try {
            $calendarId = 'primary';
            $createdEvent = $service->events->insert($calendarId, $event);
            
            $agendaModel = new Agenda();
            $agendaModel->updateGoogleEventId($id_agendamento, $createdEvent->getId());

        } catch (Exception $e) {
            // error_log('Erro na API do Google Calendar: ' . $e->getMessage());
        }
    }
    */
}
