<?php
require_once __DIR__ . '/../helpers/AuthHelper.php';
require_once __DIR__ . '/../models/Usuario.php';
require_once __DIR__ . '/../models/Eleitor.php';
require_once __DIR__ . '/../models/Documento.php';

/**
 * Controller do Painel Administrativo
 * Área restrita para administradores gerenciarem usuários e configurações do sistema
 */
class PaineladminController {

    /**
     * Página principal do painel admin
     */
    public function index() {
        // Verifica se está logado
        AuthHelper::check();
        
        // Verifica se é administrador
        if (!isset($_SESSION['usuario_nivel_acesso']) || $_SESSION['usuario_nivel_acesso'] !== 'Admin') {
            $_SESSION['erro_acesso'] = "Acesso negado. Apenas administradores podem acessar esta área.";
            header('Location: ' . BASE_URL . '/agendas');
            exit();
        }

        // Busca estatísticas gerais do sistema
        $usuarioModel = new Usuario();
        $eleitorModel = new Eleitor();
        $documentoModel = new Documento();

        $dados = [
            'totalUsuarios' => $this->getTotalUsuarios(),
            'totalEleitores' => $this->getTotalEleitores(),
            'totalDocumentos' => $this->getTotalDocumentos(),
            'usuariosRecentes' => $this->getUsuariosRecentes()
        ];

        $pageTitle = "Painel Administrativo";

        require_once __DIR__ . '/../views/partials/header.php';
        require_once __DIR__ . '/../views/paineladmin/index.php';
        require_once __DIR__ . '/../views/partials/footer.php';
    }

    /**
     * Página de gerenciamento de usuários
     */
    public function usuarios() {
        AuthHelper::check();
        
        if (!isset($_SESSION['usuario_nivel_acesso']) || $_SESSION['usuario_nivel_acesso'] !== 'Admin') {
            header('Location: ' . BASE_URL . '/agendas');
            exit();
        }

        $usuarioModel = new Usuario();
        $usuarios = $usuarioModel->getAll();

        $pageTitle = "Gerenciar Usuários";

        require_once __DIR__ . '/../views/partials/header.php';
        require_once __DIR__ . '/../views/paineladmin/usuarios.php';
        require_once __DIR__ . '/../views/partials/footer.php';
    }

    /**
     * Criar novo usuário
     */
    public function criarUsuario() {
        AuthHelper::check();
        
        if (!isset($_SESSION['usuario_nivel_acesso']) || $_SESSION['usuario_nivel_acesso'] !== 'Admin') {
            header('Location: ' . BASE_URL . '/agendas');
            exit();
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $nome = trim($_POST['nome']);
            $email = trim($_POST['email']);
            $senha = $_POST['senha'];
            $nivel_acesso = $_POST['nivel_acesso'];

            $usuarioModel = new Usuario();
            
            if ($usuarioModel->criar($nome, $email, $senha, $nivel_acesso)) {
                $_SESSION['success_message'] = "Usuário criado com sucesso!";
            } else {
                $_SESSION['error_message'] = "Erro ao criar usuário. Email pode já estar em uso.";
            }
            
            header('Location: ' . BASE_URL . '/paineladmin/usuarios');
            exit();
        }

        $pageTitle = "Criar Novo Usuário";

        require_once __DIR__ . '/../views/partials/header.php';
        require_once __DIR__ . '/../views/paineladmin/criar-usuario.php';
        require_once __DIR__ . '/../views/partials/footer.php';
    }

    // Métodos auxiliares para buscar dados
    private function getTotalUsuarios() {
        try {
            $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
            $stmt = $pdo->query("SELECT COUNT(*) FROM usuarios WHERE ativo = 1");
            return $stmt->fetchColumn();
        } catch (PDOException $e) {
            return 0;
        }
    }

    private function getTotalEleitores() {
        try {
            $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
            $stmt = $pdo->query("SELECT COUNT(*) FROM eleitores");
            return $stmt->fetchColumn();
        } catch (PDOException $e) {
            return 0;
        }
    }

    private function getTotalDocumentos() {
        try {
            $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
            $stmt = $pdo->query("SELECT COUNT(*) FROM documentos");
            return $stmt->fetchColumn();
        } catch (PDOException $e) {
            return 0;
        }
    }

    private function getUsuariosRecentes() {
        try {
            $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
            $stmt = $pdo->query("SELECT nome, email, nivel_acesso, data_criacao FROM usuarios WHERE ativo = 1 ORDER BY data_criacao DESC LIMIT 5");
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            return [];
        }
    }
}
