<?php
/**
 * AuthHelper (Assistente de Autenticação) - VERSÃO CORRIGIDA
 * Fornece métodos para gerenciar a autenticação de usuários.
 */
class AuthHelper {
    /**
     * Verifica se o usuário está logado. Se não estiver, redireciona para login.
     * CORREÇÃO PRINCIPAL: Mudança de 'user_id' para 'usuario_id' para coincidir com o UsuarioController
     */
    public static function check() {
        // Garante que a sessão foi iniciada.
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }

        // CORREÇÃO: Verifica 'usuario_id' em vez de 'user_id'
        if (isset($_SESSION['logado']) && $_SESSION['logado'] === true && isset($_SESSION['usuario_id'])) {
            return; // Usuário está logado, pode continuar
        }

        // Verifica se é uma requisição AJAX
        $isAjax = (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && 
                  strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') ||
                  (isset($_SERVER['CONTENT_TYPE']) && strpos($_SERVER['CONTENT_TYPE'], 'application/json') !== false) ||
                  (isset($_GET['ajax']) || isset($_POST['ajax']));
        
        // Para requisições AJAX, retorna JSON de erro em vez de redirecionar
        if ($isAjax) {
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Sessão expirada. Faça login novamente.',
                'redirect' => BASE_URL . '/usuario/login'
            ]);
            exit();
        }
        
        // Debug: Log para verificar se chegou até aqui
        error_log('AuthHelper: Não é AJAX, redirecionando para login. URI: ' . $_SERVER['REQUEST_URI']);

        // Pega o caminho da URL atual
        $caminhoAtual = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

        // Define as rotas que devem ser acessíveis sem login
        $rotasPublicas = [
            '/usuario/login',
            '/usuario/processarLogin'
        ];
        
        // Normaliza o caminho removendo a base do projeto
        $baseUrlPath = parse_url(BASE_URL, PHP_URL_PATH);
        if ($baseUrlPath && strpos($caminhoAtual, $baseUrlPath) === 0) {
            $caminhoAtual = substr($caminhoAtual, strlen($baseUrlPath));
        }

        // Se não está numa rota pública, redireciona para login
        if (!in_array($caminhoAtual, $rotasPublicas)) {
            header('Location: ' . BASE_URL . '/usuario/login');
            exit();
        }
    }
}
