<?php
class Eleitor {
    private $pdo;

    public function __construct() {
        try {
            $this->pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            die("Erro na conexão com o banco de dados: " . $e->getMessage());
        }
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT id, nome_completo, telefone, bairro FROM eleitores ORDER BY nome_completo ASC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Insere um novo eleitor no banco de dados com os novos campos.
     */
    public function create($dados) {
        $sql = "INSERT INTO eleitores (nome_completo, data_nascimento, telefone, email, endereco, bairro, cep, sexo, tipo, observacao)
                VALUES (:nome_completo, :data_nascimento, :telefone, :email, :endereco, :bairro, :cep, :sexo, :tipo, :observacao)";
        
        $stmt = $this->pdo->prepare($sql);

        // Associa os valores do array $dados aos parâmetros da query
        $stmt->execute([
            ':nome_completo' => $dados['nome_completo'],
            ':data_nascimento' => !empty($dados['data_nascimento']) ? $dados['data_nascimento'] : null,
            ':telefone' => $dados['telefone'] ?? null,
            ':email' => $dados['email'] ?? null,
            ':endereco' => $dados['endereco'] ?? null,
            ':bairro' => $dados['bairro'] ?? null,
            ':cep' => $dados['cep'] ?? null,
            ':sexo' => $dados['sexo'] ?? null,
            ':tipo' => $dados['tipo'],
            ':observacao' => $dados['observacao'] ?? null,
        ]);

        return $this->pdo->lastInsertId();
    }

    /**
     * Busca eleitores por nome, telefone ou bairro
     */
    public function search($termo) {
        $sql = "SELECT id, nome_completo, telefone, bairro FROM eleitores 
                WHERE nome_completo LIKE :termo 
                OR telefone LIKE :termo 
                OR bairro LIKE :termo 
                ORDER BY nome_completo ASC";
        
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute([':termo' => '%' . $termo . '%']);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Busca um eleitor por ID
     */
    public function findById($id) {
        $sql = "SELECT * FROM eleitores WHERE id = :id";
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute([':id' => $id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    /**
     * Atualiza os dados de um eleitor
     */
    public function update($id, $dados) {
        $sql = "UPDATE eleitores SET 
                nome_completo = :nome_completo,
                data_nascimento = :data_nascimento,
                telefone = :telefone,
                email = :email,
                endereco = :endereco,
                bairro = :bairro,
                cep = :cep,
                sexo = :sexo,
                tipo = :tipo,
                observacao = :observacao
                WHERE id = :id";
        
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute([
            ':id' => $id,
            ':nome_completo' => $dados['nome_completo'],
            ':data_nascimento' => !empty($dados['data_nascimento']) ? $dados['data_nascimento'] : null,
            ':telefone' => $dados['telefone'] ?? null,
            ':email' => $dados['email'] ?? null,
            ':endereco' => $dados['endereco'] ?? null,
            ':bairro' => $dados['bairro'] ?? null,
            ':cep' => $dados['cep'] ?? null,
            ':sexo' => $dados['sexo'] ?? null,
            ':tipo' => $dados['tipo'],
            ':observacao' => $dados['observacao'] ?? null,
        ]);
    }
}