<?php
require_once __DIR__ . '/../partials/header.php';
?>

<div class="min-h-screen bg-gray-50">
    <!-- Header -->
    <div class="bg-white shadow">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center py-6">
                <div>
                    <nav class="flex" aria-label="Breadcrumb">
                        <ol class="flex items-center space-x-4">
                            <li>
                                <a href="<?= BASE_URL ?>/employees" class="text-gray-400 hover:text-gray-500">
                                    <span class="sr-only">Colaboradores</span>
                                    <svg class="flex-shrink-0 h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"></path>
                                    </svg>
                                </a>
                            </li>
                            <li>
                                <div class="flex items-center">
                                    <svg class="flex-shrink-0 h-5 w-5 text-gray-300" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                                    </svg>
                                    <a href="<?= BASE_URL ?>/employees" class="ml-4 text-sm font-medium text-gray-500 hover:text-gray-700">Colaboradores</a>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center">
                                    <svg class="flex-shrink-0 h-5 w-5 text-gray-300" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                                    </svg>
                                    <a href="<?= BASE_URL ?>/employees/<?= $employee['id'] ?>" class="ml-4 text-sm font-medium text-gray-500 hover:text-gray-700"><?= htmlspecialchars($employee['full_name']) ?></a>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center">
                                    <svg class="flex-shrink-0 h-5 w-5 text-gray-300" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="ml-4 text-sm font-medium text-gray-900">Editar</span>
                                </div>
                            </li>
                        </ol>
                    </nav>
                    <h1 class="mt-2 text-3xl font-bold text-gray-900">Editar Colaborador</h1>
                    <p class="mt-1 text-sm text-gray-600">Atualize os dados de <?= htmlspecialchars($employee['full_name']) ?></p>
                </div>
            </div>
        </div>
    </div>

    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Mensagens de Erro -->
        <?php if (isset($_SESSION['errors']) && !empty($_SESSION['errors'])): ?>
            <div class="mb-6 bg-red-50 border border-red-200 rounded-md p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-red-800">Corrija os seguintes erros:</h3>
                        <div class="mt-2 text-sm text-red-700">
                            <ul class="list-disc pl-5 space-y-1">
                                <?php foreach ($_SESSION['errors'] as $error): ?>
                                    <li><?= htmlspecialchars($error) ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <?php unset($_SESSION['errors']); ?>
        <?php endif; ?>

        <!-- Formulário -->
        <form method="POST" action="<?= BASE_URL ?>/employees/<?= $employee['id'] ?>/update" class="space-y-8">
            <!-- Dados Pessoais -->
            <div class="bg-white shadow px-4 py-5 sm:rounded-lg sm:p-6">
                <div class="md:grid md:grid-cols-3 md:gap-6">
                    <div class="md:col-span-1">
                        <h3 class="text-lg font-medium leading-6 text-gray-900">Dados Pessoais</h3>
                        <p class="mt-1 text-sm text-gray-500">Informações básicas do colaborador.</p>
                    </div>
                    <div class="mt-5 md:mt-0 md:col-span-2">
                        <div class="grid grid-cols-6 gap-6">
                            <div class="col-span-6">
                                <label for="full_name" class="block text-sm font-medium text-gray-700">Nome Completo *</label>
                                <input type="text" name="full_name" id="full_name" required
                                       value="<?= htmlspecialchars($_SESSION['old']['full_name'] ?? $employee['full_name']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="cpf" class="block text-sm font-medium text-gray-700">CPF *</label>
                                <input type="text" name="cpf" id="cpf" required maxlength="14" placeholder="000.000.000-00"
                                       value="<?= htmlspecialchars($_SESSION['old']['cpf'] ?? $employee['cpf']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="rg" class="block text-sm font-medium text-gray-700">RG</label>
                                <input type="text" name="rg" id="rg"
                                       value="<?= htmlspecialchars($_SESSION['old']['rg'] ?? $employee['rg']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="birth_date" class="block text-sm font-medium text-gray-700">Data de Nascimento</label>
                                <input type="date" name="birth_date" id="birth_date"
                                       value="<?= htmlspecialchars($_SESSION['old']['birth_date'] ?? $employee['birth_date']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="phone_number" class="block text-sm font-medium text-gray-700">Telefone</label>
                                <input type="text" name="phone_number" id="phone_number" placeholder="(00) 00000-0000"
                                       value="<?= htmlspecialchars($_SESSION['old']['phone_number'] ?? $employee['phone_number']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>

                            <div class="col-span-6">
                                <label for="address" class="block text-sm font-medium text-gray-700">Endereço</label>
                                <textarea name="address" id="address" rows="3"
                                          class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md"><?= htmlspecialchars($_SESSION['old']['address'] ?? $employee['address']) ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dados Contratuais -->
            <div class="bg-white shadow px-4 py-5 sm:rounded-lg sm:p-6">
                <div class="md:grid md:grid-cols-3 md:gap-6">
                    <div class="md:col-span-1">
                        <h3 class="text-lg font-medium leading-6 text-gray-900">Dados Contratuais</h3>
                        <p class="mt-1 text-sm text-gray-500">Informações sobre o contrato de trabalho.</p>
                    </div>
                    <div class="mt-5 md:mt-0 md:col-span-2">
                        <div class="grid grid-cols-6 gap-6">
                            <div class="col-span-6 sm:col-span-3">
                                <label for="job_title" class="block text-sm font-medium text-gray-700">Cargo *</label>
                                <input type="text" name="job_title" id="job_title" required
                                       value="<?= htmlspecialchars($_SESSION['old']['job_title'] ?? $employee['job_title']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="salary" class="block text-sm font-medium text-gray-700">Salário *</label>
                                <div class="mt-1 relative rounded-md shadow-sm">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 sm:text-sm">R$</span>
                                    </div>
                                    <input type="text" name="salary" id="salary" required placeholder="0,00"
                                           value="<?= htmlspecialchars($_SESSION['old']['salary'] ?? number_format($employee['salary'], 2, ',', '.')) ?>"
                                           class="focus:ring-blue-500 focus:border-blue-500 block w-full pl-12 pr-12 sm:text-sm border-gray-300 rounded-md">
                                </div>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="hire_date" class="block text-sm font-medium text-gray-700">Data de Admissão *</label>
                                <input type="date" name="hire_date" id="hire_date" required
                                       value="<?= htmlspecialchars($_SESSION['old']['hire_date'] ?? $employee['hire_date']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="contract_type" class="block text-sm font-medium text-gray-700">Tipo de Contrato *</label>
                                <select name="contract_type" id="contract_type" required
                                        class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                    <option value="">Selecione...</option>
                                    <option value="CLT" <?= (($_SESSION['old']['contract_type'] ?? $employee['contract_type']) === 'CLT') ? 'selected' : '' ?>>CLT</option>
                                    <option value="PJ" <?= (($_SESSION['old']['contract_type'] ?? $employee['contract_type']) === 'PJ') ? 'selected' : '' ?>>PJ</option>
                                    <option value="Estagiario" <?= (($_SESSION['old']['contract_type'] ?? $employee['contract_type']) === 'Estagiario') ? 'selected' : '' ?>>Estagiário</option>
                                    <option value="Terceirizado" <?= (($_SESSION['old']['contract_type'] ?? $employee['contract_type']) === 'Terceirizado') ? 'selected' : '' ?>>Terceirizado</option>
                                </select>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="status" class="block text-sm font-medium text-gray-700">Status *</label>
                                <select name="status" id="status" required
                                        class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                    <option value="ativo" <?= (($_SESSION['old']['status'] ?? $employee['status']) === 'ativo') ? 'selected' : '' ?>>Ativo</option>
                                    <option value="inativo" <?= (($_SESSION['old']['status'] ?? $employee['status']) === 'inativo') ? 'selected' : '' ?>>Inativo</option>
                                    <option value="demitido" <?= (($_SESSION['old']['status'] ?? $employee['status']) === 'demitido') ? 'selected' : '' ?>>Demitido</option>
                                </select>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="cost_center" class="block text-sm font-medium text-gray-700">Centro de Custo</label>
                                <input type="text" name="cost_center" id="cost_center"
                                       value="<?= htmlspecialchars($_SESSION['old']['cost_center'] ?? $employee['cost_center']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dados Bancários -->
            <div class="bg-white shadow px-4 py-5 sm:rounded-lg sm:p-6">
                <div class="md:grid md:grid-cols-3 md:gap-6">
                    <div class="md:col-span-1">
                        <h3 class="text-lg font-medium leading-6 text-gray-900">Dados Bancários</h3>
                        <p class="mt-1 text-sm text-gray-500">Informações para pagamento do salário.</p>
                    </div>
                    <div class="mt-5 md:mt-0 md:col-span-2">
                        <div class="grid grid-cols-6 gap-6">
                            <div class="col-span-6 sm:col-span-2">
                                <label for="bank_name" class="block text-sm font-medium text-gray-700">Banco</label>
                                <input type="text" name="bank_name" id="bank_name"
                                       value="<?= htmlspecialchars($_SESSION['old']['bank_name'] ?? $employee['bank_name']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>

                            <div class="col-span-6 sm:col-span-2">
                                <label for="agency_number" class="block text-sm font-medium text-gray-700">Agência</label>
                                <input type="text" name="agency_number" id="agency_number"
                                       value="<?= htmlspecialchars($_SESSION['old']['agency_number'] ?? $employee['agency_number']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>

                            <div class="col-span-6 sm:col-span-2">
                                <label for="account_number" class="block text-sm font-medium text-gray-700">Conta</label>
                                <input type="text" name="account_number" id="account_number"
                                       value="<?= htmlspecialchars($_SESSION['old']['account_number'] ?? $employee['account_number']) ?>"
                                       class="mt-1 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Botões -->
            <div class="flex justify-end space-x-3">
                <a href="<?= BASE_URL ?>/employees/<?= $employee['id'] ?>" 
                   class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    Cancelar
                </a>
                <button type="submit" 
                        class="ml-3 inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    Salvar Alterações
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Máscara para CPF
document.getElementById('cpf').addEventListener('input', function(e) {
    let value = e.target.value.replace(/\D/g, '');
    value = value.replace(/(\d{3})(\d)/, '$1.$2');
    value = value.replace(/(\d{3})(\d)/, '$1.$2');
    value = value.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
    e.target.value = value;
});

// Máscara para telefone
document.getElementById('phone_number').addEventListener('input', function(e) {
    let value = e.target.value.replace(/\D/g, '');
    value = value.replace(/(\d{2})(\d)/, '($1) $2');
    value = value.replace(/(\d{4,5})(\d{4})$/, '$1-$2');
    e.target.value = value;
});

// Máscara para salário
document.getElementById('salary').addEventListener('input', function(e) {
    let value = e.target.value.replace(/\D/g, '');
    value = (value / 100).toFixed(2) + '';
    value = value.replace('.', ',');
    value = value.replace(/(\d)(\d{3})(\d{3}),/g, '$1.$2.$3,');
    value = value.replace(/(\d)(\d{3}),/g, '$1.$2,');
    e.target.value = value;
});
</script>

<?php 
unset($_SESSION['old']);
require_once __DIR__ . '/../partials/footer.php'; 
?>