<?php
// Teste completo dentro do sistema de rotas
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../models/Usuario.php';
require_once __DIR__ . '/../models/Agenda.php';

// Inicia a sessão
session_start();

header('Content-Type: text/html; charset=UTF-8');

echo "<h2>Teste Completo do Sistema</h2>";

// 1. Verificar usuários existentes
echo "<h3>1. Usuários no Sistema</h3>";
try {
    $usuario = new Usuario();
    $usuarios = $usuario->getAll();
    
    if ($usuarios) {
        echo "<table border='1'>";
        echo "<tr><th>ID</th><th>Nome</th><th>Email</th><th>Nível</th><th>Ativo</th></tr>";
        foreach ($usuarios as $u) {
            echo "<tr>";
            echo "<td>" . $u['id'] . "</td>";
            echo "<td>" . $u['nome'] . "</td>";
            echo "<td>" . $u['email'] . "</td>";
            echo "<td>" . $u['nivel_acesso'] . "</td>";
            echo "<td>" . ($u['ativo'] ? 'Sim' : 'Não') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "❌ Nenhum usuário encontrado<br>";
    }
} catch (Exception $e) {
    echo "❌ Erro ao buscar usuários: " . $e->getMessage() . "<br>";
}

echo "<hr>";

// 2. Simular login com o primeiro usuário ativo
echo "<h3>2. Simulando Login</h3>";
if (!empty($usuarios)) {
    $primeiroUsuario = null;
    foreach ($usuarios as $u) {
        if ($u['ativo']) {
            $primeiroUsuario = $u;
            break;
        }
    }
    
    if ($primeiroUsuario) {
        // Simular sessão logada
        $_SESSION['logado'] = true;
        $_SESSION['usuario_id'] = $primeiroUsuario['id'];
        $_SESSION['usuario_nome'] = $primeiroUsuario['nome'];
        $_SESSION['usuario_email'] = $primeiroUsuario['email'];
        
        echo "✅ Sessão simulada para usuário:<br>";
        echo "- ID: " . $primeiroUsuario['id'] . "<br>";
        echo "- Nome: " . $primeiroUsuario['nome'] . "<br>";
        echo "- Email: " . $primeiroUsuario['email'] . "<br>";
    }
}

echo "<hr>";

// 3. Testar criação de agendamento
echo "<h3>3. Testando Criação de Agendamento</h3>";
if (isset($_SESSION['usuario_id'])) {
    try {
        $agenda = new Agenda();
        
        $dados = [
            'titulo' => 'Teste Sistema Completo',
            'data_inicio' => '2024-01-20 14:00:00',
            'data_fim' => '2024-01-20 15:00:00',
            'categoria' => 'reuniao',
            'descricao' => 'Teste de agendamento completo do sistema',
            'id_eleitor' => 1,
            'id_responsavel' => $_SESSION['usuario_id'],
            'whatsapp_notificacao' => 1
        ];
        
        echo "Dados do agendamento:<br>";
        echo "<pre>" . print_r($dados, true) . "</pre>";
        
        $resultado = $agenda->create($dados);
        
        if ($resultado) {
            echo "✅ Agendamento criado com sucesso! ID: " . $resultado . "<br>";
            
            // Resposta JSON simulada
            $response = [
                'status' => 'success',
                'message' => 'Agendamento criado com sucesso!',
                'data' => [
                    'id' => $resultado,
                    'titulo' => $dados['titulo'],
                    'whatsapp_notificacao' => $dados['whatsapp_notificacao']
                ]
            ];
            
            echo "<h4>Resposta JSON:</h4>";
            echo "<pre>" . json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            
        } else {
            echo "❌ Falha ao criar agendamento<br>";
        }
        
    } catch (Exception $e) {
        echo "❌ Erro ao criar agendamento: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ Usuário não está logado<br>";
}

echo "<hr>";
echo "<h3>✅ Teste Concluído</h3>";
?>